'use strict';

/* --------------------------------------------------------------
 bottom_save_bar.js 2017-09-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Bottom Save Bar Module
 *
 * This module will move all content, that is contained in any element that has the class "bottom-save-bar-content" to
 * the Bottom Save Bar.
 *
 * @module Compatibility/bottom_save_bar
 */
gx.compatibility.module(
// Module name
'bottom_save_bar',

// Module dependencies
[],

/**  @lends module:Compatibility/bottom_save_bar */

function () {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    var module = {},
        $target = $('.bottom-save-bar');

    // ------------------------------------------------------------------------
    // EVENT HANDLER
    // ------------------------------------------------------------------------

    var _initialize = function _initialize() {
        $('.bottom-save-bar-content > *:not([type="hidden"]):not(.btn-primary)').each(function (index, element) {
            var $element = $(element).css('float', 'none');
            _handleContentType($element);
        });

        $('.bottom-save-bar-content > *.btn-primary:not([type="hidden"])').each(function (index, element) {
            var $element = $(element).css('float', 'none');
            _handleContentType($element);
        });
    };

    var _handleContentType = function _handleContentType($element) {
        if ($element.is('input:not([type="button"])') || $element.is('button[type="submit"]')) {
            _handleFormElement($element);
        } else {
            _handleOtherContent($element);
        }
    };

    var _handleFormElement = function _handleFormElement($element) {
        var $clone = $element.clone();
        $element.hide();

        if ($element.is('[type="submit"]')) {
            $clone.attr('type', 'button');
        }

        $clone.on('click', function () {
            $element.trigger('click');
        });

        $target.append($clone);
    };

    var _handleOtherContent = function _handleOtherContent($element) {
        $target.append($element);
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        _initialize();
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
